<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RecruiterUser extends Model 
{

    protected $table = 're_users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('mobile', 'email', 'otp', 'status');
    protected $hidden = array('password');

    public function jobs()
    {
        return $this->hasMany('App\Models\Job');
    }

}